<!DOCTYPE html>
<html lang="fa" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>{{ $test->title }}</title>
    <style>
        * { margin: 0; padding: 0; box-sizing: border-box; }
        body {
            font-family: 'Tahoma', 'Segoe UI', sans-serif;
            background: linear-gradient(135deg, #1a1a2e 0%, #16213e 100%);
            min-height: 100vh;
            display: flex;
            justify-content: center;
            align-items: center;
            padding: 20px;
            color: #e4e4e4;
        }
        .container {
            background: rgba(30, 30, 50, 0.95);
            border-radius: 20px;
            padding: 40px;
            width: 100%;
            max-width: 600px;
            box-shadow: 0 20px 60px rgba(0, 0, 0, 0.5);
            border: 1px solid rgba(255, 255, 255, 0.1);
        }
        h2 {
            text-align: center;
            color: #00d9ff;
            margin-bottom: 10px;
            font-size: 24px;
        }
        .test-description {
            text-align: center;
            color: #888;
            margin-bottom: 30px;
            font-size: 14px;
        }
        .form-group {
            margin-bottom: 20px;
        }
        label {
            display: block;
            margin-bottom: 8px;
            color: #b0b0b0;
            font-size: 14px;
        }
        input[type="text"],
        input[type="tel"] {
            width: 100%;
            padding: 12px 15px;
            border: 2px solid rgba(255, 255, 255, 0.1);
            border-radius: 10px;
            background: rgba(40, 40, 60, 0.8);
            color: #fff;
            font-size: 14px;
            transition: all 0.3s ease;
        }
        input[type="text"]:focus,
        input[type="tel"]:focus {
            outline: none;
            border-color: #00d9ff;
            box-shadow: 0 0 15px rgba(0, 217, 255, 0.3);
        }
        .question-card {
            background: rgba(40, 40, 60, 0.5);
            padding: 20px;
            border-radius: 12px;
            margin-bottom: 20px;
            border-right: 4px solid #00d9ff;
            transition: all 0.3s ease;
        }
        .question-card:hover {
            background: rgba(40, 40, 60, 0.8);
            transform: translateX(-5px);
        }
        .question-title {
            color: #00d9ff;
            font-size: 16px;
            margin-bottom: 15px;
        }
        .question-number {
            background: rgba(0, 217, 255, 0.2);
            color: #00d9ff;
            padding: 3px 10px;
            border-radius: 15px;
            font-size: 12px;
            margin-left: 10px;
        }
        .options-group {
            display: flex;
            flex-direction: column;
            gap: 10px;
        }
        .option-label {
            display: flex;
            align-items: center;
            padding: 12px 15px;
            background: rgba(50, 50, 70, 0.5);
            border-radius: 8px;
            cursor: pointer;
            transition: all 0.3s ease;
            border: 2px solid transparent;
        }
        .option-label:hover {
            background: rgba(50, 50, 70, 0.8);
            border-color: rgba(0, 217, 255, 0.3);
        }
        .option-label input[type="radio"] {
            margin-left: 12px;
            width: 18px;
            height: 18px;
            accent-color: #00d9ff;
        }
        .option-label input[type="radio"]:checked + span {
            color: #00d9ff;
            font-weight: bold;
        }
        .option-label:has(input:checked) {
            border-color: #00d9ff;
            background: rgba(0, 217, 255, 0.1);
        }
        .option-text {
            color: #d0d0d0;
            flex: 1;
        }
        .submit-btn {
            width: 100%;
            padding: 15px;
            background: linear-gradient(135deg, #00d9ff 0%, #0099cc 100%);
            border: none;
            border-radius: 10px;
            color: #fff;
            font-size: 16px;
            font-weight: bold;
            cursor: pointer;
            transition: all 0.3s ease;
            margin-top: 25px;
        }
        .submit-btn:hover {
            transform: translateY(-3px);
            box-shadow: 0 10px 30px rgba(0, 217, 255, 0.4);
        }
        .success-message {
            background: rgba(0, 255, 136, 0.1);
            border: 2px solid #00ff88;
            color: #00ff88;
            padding: 20px;
            border-radius: 10px;
            text-align: center;
            margin-top: 20px;
        }
    </style>
</head>
<body>
    <div class="container">
        <h2>{{ $test->title }}</h2>
        <p class="test-description">{{ $test->description }}</p>

      @if(session('success'))
    <div class="success-message">
        <h3>✅ {{ session('success') }}</h3>
        <p>امتیاز کل: <strong style="color: #00ff88; font-size: 24px;">{{ session('total_score') }}</strong></p>
        
        @if(session('question_results'))
            <hr style="border: 1px solid rgba(255,255,255,0.1); margin: 20px 0;">
            <h4 style="color: #00d9ff; margin-bottom: 15px;">📊 نتیجه هر سوال:</h4>
            
            @foreach(session('question_results') as $questionId => $result)
                <div style="background: rgba(0, 217, 255, 0.1); padding: 15px 20px; border-radius: 10px; margin-bottom: 12px; border-right: 4px solid #00d9ff;">
                    <div style="display: flex; justify-content: space-between; align-items: center;">
                        <span style="color: #b0b0b0; font-size: 14px;">{{ $result['question_text'] }}</span>
                        <strong style="color: #00d9ff; font-size: 22px;">{{ $result['score'] }}</strong>
                    </div>
                </div>
            @endforeach
        @endif
        
        <a href="{{ route('tests.show', $test->id) }}" style="color: #00d9ff; margin-top: 20px; display: inline-block;">🔄 تست مجدد</a>
    </div>


        @else
            <form action="{{ route('tests.submit', $test->id) }}" method="POST">
                @csrf
                
                <div class="form-group">
                    <label for="participant_name">نام و نام خانوادگی</label>
                    <input type="text" id="participant_name" name="participant_name" required placeholder="نام خود را وارد کنید">
                </div>
                
                <div class="form-group">
                    <label for="participant_phone">شماره تماس</label>
                    <input type="tel" id="participant_phone" name="participant_phone" required placeholder="09xxxxxxxxx">
                </div>

                <hr style="border: 1px solid rgba(255,255,255,0.1); margin: 30px 0;">

                @foreach($test->questions as $question)
                    <div class="question-card">
                        <div class="question-title">
                            <span class="question-number">سوال {{ $loop->iteration }}</span>
                            {{ $question->text }}
                            @if($question->is_required)
                                <span style="color: #ff4757; font-size: 12px;">*</span>
                            @endif
                        </div>

                        @if($question->type === 'multiple_choice')
                            <div class="options-group">
                                @foreach($question->options as $option)
                                    <label class="option-label">
                                        <input type="radio" 
                                               name="answers[{{ $question->id }}][option_id]" 
                                               value="{{ $option->id }}"
                                               @if($question->is_required) required @endif>
                                        <span class="option-text">{{ $option->text }}</span>
                                    </label>
                                @endforeach
                            </div>
                        @elseif($question->type === 'descriptive')
                            <input type="text" 
                                   name="answers[{{ $question->id }}][text_answer]" 
                                   placeholder="پاسخ خود را بنویسید..."
                                   @if($question->is_required) required @endif>
                        @endif

                        <input type="hidden" name="answers[{{ $question->id }}][question_id]" value="{{ $question->id }}">
                    </div>
                @endforeach

                <button type="submit" class="submit-btn">🚀 ثبت پاسخ‌ها</button>
            </form>
        @endif
    </div>
</body>
</html>