<!DOCTYPE html>
<html lang="fa" dir="rtl">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>ساخت تست جدید</title>

<style>
* { margin: 0; padding: 0; box-sizing: border-box; }

body {
    font-family: Tahoma, Arial, sans-serif;
    background: radial-gradient(circle at top, #1c1f2b 0%, #0e1018 70%);
    min-height: 100vh;
    padding: 40px 20px 160px;
    color: #e6e6e6;
    overflow-x: hidden;
}

/* گل‌های پس‌زمینه */
body::before,
body::after {
    content: "✿ ❀ ✿ ❀ ✿ ❀";
    position: fixed;
    font-size: 28px;
    opacity: 0.05;
    color: #ff9ad5;
    letter-spacing: 30px;
    white-space: nowrap;
    pointer-events: none;
}

body::before {
    top: 30px;
    right: -100px;
    transform: rotate(-5deg);
}

body::after {
    bottom: 220px;
    left: -120px;
    transform: rotate(7deg);
}

.container {
    max-width: 720px;
    margin: 0 auto;
    background: rgba(20, 23, 36, 0.95);
    border-radius: 18px;
    padding: 35px 40px;
    box-shadow:
        0 30px 60px rgba(0,0,0,0.6),
        inset 0 0 0 1px rgba(255,255,255,0.04);
    position: relative;
}

/* گل گوشه کارت */
.container::after {
    content: "🌸";
    position: absolute;
    top: -18px;
    left: -18px;
    font-size: 42px;
    opacity: 0.25;
}

/* لینک بازگشت */
.back-link {
    display: inline-block;
    color: #9adfff;
    margin-bottom: 20px;
    text-decoration: none;
    font-size: 14px;
}
.back-link:hover { text-decoration: underline; }

/* عنوان */
h1 {
    text-align: center;
    color: #ffd1ea;
    margin-bottom: 35px;
    font-size: 26px;
    letter-spacing: 1px;
}

h1::after {
    content: "آرام، زیبا، حتی در تاریکی ✨";
    display: block;
    margin-top: 10px;
    font-size: 13px;
    color: #aaa;
}

/* فرم */
.form-group { margin-bottom: 26px; }

label {
    display: block;
    margin-bottom: 8px;
    color: #ddd;
    font-weight: bold;
    font-size: 14px;
}

input[type="text"],
textarea {
    width: 100%;
    padding: 14px 16px;
    border-radius: 10px;
    border: 1px solid #2e3245;
    background: #121421;
    color: #eee;
    font-size: 14px;
    transition: all 0.25s ease;
}

input::placeholder,
textarea::placeholder {
    color: #666;
}

input:focus,
textarea:focus {
    outline: none;
    border-color: #ff9ad5;
    box-shadow: 0 0 0 3px rgba(255,154,213,0.25);
    background: #15182a;
}

textarea {
    min-height: 120px;
    resize: vertical;
}

/* چک‌باکس */
.checkbox-group {
    display: flex;
    align-items: center;
    gap: 10px;
    padding: 14px 16px;
    background: #15182a;
    border-radius: 10px;
    border: 1px solid #2e3245;
}

.checkbox-group input {
    transform: scale(1.2);
    cursor: pointer;
}

.checkbox-group label {
    margin: 0;
    font-weight: normal;
    color: #eee;
}

/* دکمه‌ها */
.btn-group {
    display: flex;
    gap: 15px;
    margin-top: 35px;
}

.btn {
    flex: 1;
    padding: 14px 20px;
    border-radius: 12px;
    border: none;
    font-size: 15px;
    font-weight: bold;
    cursor: pointer;
    transition: all 0.3s ease;
}

.btn-primary {
    background: linear-gradient(135deg, #ff9ad5, #b388ff);
    color: #1a0f1f;
    box-shadow: 0 12px 25px rgba(179,136,255,0.35);
}

.btn-primary:hover {
    transform: translateY(-2px);
    box-shadow: 0 16px 30px rgba(179,136,255,0.5);
}

.btn-secondary {
    background: #2a2d40;
    color: #ccc;
}

.btn-secondary:hover {
    background: #343856;
}

/* خطاها */
.alert {
    padding: 15px;
    border-radius: 10px;
    margin-bottom: 25px;
    background: rgba(120,30,60,0.25);
    border-right: 4px solid #ff6b9a;
    color: #ffd1e1;
}

.error {
    margin-top: 6px;
    font-size: 13px;
    color: #ff8fb3;
}

/* 🔥 آتش پایین صفحه */
.fire {
    position: fixed;
    bottom: 0;
    left: 0;
    width: 100%;
    height: 140px;
    background: radial-gradient(ellipse at center bottom,
        #ffdd99 0%,
        #ff9f43 25%,
        #ff6a00 45%,
        #d84315 65%,
        transparent 75%);
    filter: blur(1px);
    animation: fireMove 3s infinite ease-in-out;
    pointer-events: none;
}

.fire::before,
.fire::after {
    content: "";
    position: absolute;
    bottom: 0;
    width: 120%;
    height: 100%;
    background: inherit;
    animation: flameWave 2.5s infinite ease-in-out;
    opacity: 0.8;
}

.fire::after {
    animation-duration: 3.5s;
    opacity: 0.6;
}

@keyframes fireMove {
    0%,100% { transform: scaleY(1); }
    50% { transform: scaleY(1.1); }
}

@keyframes flameWave {
    0% { transform: translateX(-5%) scaleY(1); }
    50% { transform: translateX(5%) scaleY(1.15); }
    100% { transform: translateX(-5%) scaleY(1); }
}
</style>
</head>

<body>

<div class="container">

    <a href="{{ route('admin.tests.index') }}" class="back-link">
        ← بازگشت به لیست تست‌ها
    </a>

    <h1>🌙 ساخت تست جدید</h1>

    @if($errors->any())
        <div class="alert">
            <ul style="margin: 0; padding-right: 20px;">
                @foreach($errors->all() as $error)
                    <li>{{ $error }}</li>
                @endforeach
            </ul>
        </div>
    @endif

    <form action="{{ route('admin.tests.store') }}" method="POST">
        @csrf

        <div class="form-group">
            <label for="title">عنوان تست *</label>
            <input type="text" id="title" name="title"
                   value="{{ old('title') }}" required>
        </div>

        <div class="form-group">
            <label for="description">توضیحات</label>
            <textarea id="description" name="description">{{ old('description') }}</textarea>
        </div>

        <div class="form-group">
            <div class="checkbox-group">
                <input type="checkbox" id="is_active" name="is_active" value="1"
                       {{ old('is_active') ? 'checked' : '' }}>
                <label for="is_active">تست فعال باشد</label>
            </div>
        </div>

        <div class="btn-group">
            <button type="submit" class="btn btn-primary">🌸 ذخیره تست</button>
            <a href="{{ route('admin.tests.index') }}" class="btn btn-secondary">انصراف</a>
        </div>
    </form>

</div>

<div class="fire"></div>

</body>
</html>
