<!DOCTYPE html>
<html lang="fa" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>ویرایش فرمول - {{ $formula->name }}</title>
    <style>
        /* 🕌 فونت‌های فارسی */
        @font-face {
            font-family: 'Vazir';
            src: local('Vazir'), local('Tahoma'), local('Arial');
        }

        * { margin: 0; padding: 0; box-sizing: border-box; }

        body {
            font-family: 'Vazir', Tahoma, Arial, sans-serif;
            background:
                radial-gradient(ellipse at top, #f8f4e9 0%, #e8dcc8 40%, #d4c4a8 100%),
                repeating-linear-gradient(45deg, transparent, transparent 10px, rgba(18, 52, 86, 0.03) 10px, rgba(18, 52, 86, 0.03) 20px);
            min-height: 100vh;
            padding: 40px 20px;
            color: #2c3e50;
            position: relative;
            overflow-x: hidden;
        }

        /* 🕌 الگوی هندسی اسلامی در پس‌زمینه */
        body::before {
            content: "";
            position: fixed;
            inset: 0;
            background-image:
                radial-gradient(circle at 25px 25px, rgba(18, 52, 86, 0.08) 2px, transparent 3px),
                radial-gradient(circle at 75px 75px, rgba(18, 52, 86, 0.05) 1px, transparent 2px);
            background-size: 100px 100px;
            pointer-events: none;
            z-index: 0;
        }

        /* 🕌 نوار تزئینی بالای صفحه */
        .islamic-border-top {
            position: fixed;
            top: 0; left: 0; right: 0;
            height: 8px;
            background: repeating-linear-gradient(
                90deg,
                #123456 0px, #123456 20px,
                #c9a961 20px, #c9a961 40px,
                #1abc9c 40px, #1abc9c 60px,
                #c9a961 60px, #c9a961 80px
            );
            z-index: 100;
            box-shadow: 0 2px 10px rgba(18, 52, 86, 0.2);
        }

        .container {
            max-width: 700px;
            margin: 60px auto 40px;
            position: relative;
            z-index: 5;
        }

        /* 🕌 کارت با الهام از طاق و محراب */
        .card {
            background: linear-gradient(145deg, #fffef9, #f5f0e1);
            border: 2px solid #c9a961;
            border-radius: 20px 20px 8px 8px;
            box-shadow:
                0 10px 40px rgba(18, 52, 86, 0.15),
                inset 0 1px 0 rgba(255,255,255,0.8),
                0 0 0 4px rgba(18, 52, 86, 0.05);
            padding: 35px;
            position: relative;
            overflow: hidden;
        }

        /* 🕌 تزئین گوشه‌های کارت (الهام از گره‌چینی) */
        .card::before,
        .card::after {
            content: "";
            position: absolute;
            width: 60px; height: 60px;
            border: 3px solid #c9a961;
            opacity: 0.6;
        }
        .card::before {
            top: 15px; right: 15px;
            border-left: none; border-bottom: none;
            border-radius: 0 8px 0 0;
        }
        .card::after {
            bottom: 15px; left: 15px;
            border-right: none; border-top: none;
            border-radius: 0 0 0 8px;
        }

        /* 🕌 عنوان با الهام از کتیبه‌نویسی */
        .header {
            text-align: center;
            margin-bottom: 30px;
            padding-bottom: 20px;
            border-bottom: 2px dashed #c9a961;
            position: relative;
        }
        .header::after {
            content: "✦";
            position: absolute;
            bottom: -12px; left: 50%;
            transform: translateX(-50%);
            background: #f5f0e1;
            padding: 0 15px;
            color: #c9a961;
            font-size: 20px;
        }
        .header h1 {
            color: #123456;
            font-size: 22px;
            font-weight: bold;
            letter-spacing: 1px;
            text-shadow: 0 1px 0 rgba(255,255,255,0.8);
        }
        .header .subtitle {
            color: #1abc9c;
            font-size: 13px;
            margin-top: 8px;
            font-weight: normal;
        }

        /* 🕌 اطلاعات تست */
        .test-info {
            background: linear-gradient(135deg, rgba(26, 188, 156, 0.1), rgba(18, 52, 86, 0.05));
            border-right: 4px solid #1abc9c;
            padding: 15px 20px;
            border-radius: 8px;
            margin-bottom: 25px;
        }
        .test-info h3 {
            color: #123456;
            font-size: 14px;
            margin-bottom: 5px;
        }
        .test-info p {
            color: #555;
            font-size: 13px;
        }

        /* 🕌 فیلدهای فرم */
        .form-group { margin-bottom: 22px; }

        label {
            display: block;
            color: #123456;
            margin-bottom: 8px;
            font-weight: bold;
            font-size: 13px;
            position: relative;
            padding-right: 18px;
        }
        label::before {
            content: "◖";
            position: absolute;
            right: 0; top: 2px;
            color: #c9a961;
            font-size: 12px;
        }

        input[type="text"],
        input[type="number"],
        textarea,
        select {
            width: 100%;
            padding: 12px 15px;
            border: 2px solid #d4c4a8;
            border-radius: 8px;
            background: #fffef9;
            color: #2c3e50;
            font-size: 14px;
            font-family: inherit;
            transition: all 0.3s ease;
        }
        input:focus, textarea:focus, select:focus {
            outline: none;
            border-color: #1abc9c;
            background: #fff;
            box-shadow: 0 0 0 4px rgba(26, 188, 156, 0.15);
        }
        textarea {
            min-height: 90px;
            resize: vertical;
            line-height: 1.6;
        }

        /* 🕌 چک‌باکس با استایل اسلامی */
        .checkbox-wrapper {
            display: flex;
            align-items: center;
            gap: 12px;
            padding: 15px;
            background: linear-gradient(135deg, rgba(201, 169, 97, 0.1), rgba(18, 52, 86, 0.03));
            border: 1px solid #c9a961;
            border-radius: 8px;
            cursor: pointer;
        }
        .checkbox-wrapper input {
            width: 20px; height: 20px;
            accent-color: #1abc9c;
            cursor: pointer;
        }
        .checkbox-wrapper label {
            margin: 0;
            padding-right: 0;
            font-weight: normal;
            color: #2c3e50;
            font-size: 13px;
        }
        .checkbox-wrapper label::before { display: none; }

        .hint {
            font-size: 11px;
            color: #7f8c8d;
            margin-top: 6px;
            padding-right: 18px;
            font-style: italic;
        }

        /* 🕌 دکمه‌ها با الهام از کاشی‌کاری */
        .btn-group {
            display: flex;
            gap: 15px;
            margin-top: 35px;
            padding-top: 25px;
            border-top: 2px dashed #c9a961;
        }
        .btn {
            flex: 1;
            padding: 14px 20px;
            border-radius: 10px;
            border: none;
            font-size: 14px;
            font-weight: bold;
            font-family: inherit;
            cursor: pointer;
            text-align: center;
            text-decoration: none;
            transition: all 0.3s ease;
            position: relative;
            overflow: hidden;
        }
        .btn::before {
            content: "";
            position: absolute;
            inset: 0;
            background: linear-gradient(135deg, rgba(255,255,255,0.2), transparent);
            opacity: 0;
            transition: opacity 0.3s;
        }
        .btn:hover::before { opacity: 1; }

        .btn-primary {
            background: linear-gradient(135deg, #1abc9c, #16a085);
            color: #fff;
            box-shadow: 0 4px 15px rgba(26, 188, 156, 0.4);
        }
        .btn-primary:hover {
            background: linear-gradient(135deg, #16a085, #138d75);
            transform: translateY(-2px);
            box-shadow: 0 6px 20px rgba(26, 188, 156, 0.6);
        }

        .btn-secondary {
            background: linear-gradient(135deg, #ecf0f1, #bdc3c7);
            color: #2c3e50;
            border: 2px solid #95a5a6;
        }
        .btn-secondary:hover {
            background: linear-gradient(135deg, #bdc3c7, #95a5a6);
            color: #fff;
            transform: translateY(-2px);
        }

        /* 🕌 پیام‌های خطا و موفقیت */
        .alert {
            padding: 15px 20px;
            border-radius: 10px;
            margin-bottom: 25px;
            font-size: 13px;
            position: relative;
            padding-right: 45px;
        }
        .alert::before {
            content: "✦";
            position: absolute;
            right: 15px; top: 50%;
            transform: translateY(-50%);
            font-size: 18px;
        }
        .alert-success {
            background: linear-gradient(135deg, rgba(26, 188, 156, 0.15), rgba(26, 188, 156, 0.05));
            border-right: 4px solid #1abc9c;
            color: #16a085;
        }
        .alert-success::before { color: #1abc9c; }

        .alert-error {
            background: linear-gradient(135deg, rgba(231, 76, 60, 0.15), rgba(231, 76, 60, 0.05));
            border-right: 4px solid #e74c3c;
            color: #c0392b;
        }
        .alert-error::before { content: "⚠"; color: #e74c3c; }
        .alert-error ul {
            margin: 0;
            padding-right: 20px;
        }

        /* 🕌 لینک بازگشت */
        .back-link {
            display: inline-flex;
            align-items: center;
            gap: 8px;
            color: #1abc9c;
            margin-bottom: 25px;
            text-decoration: none;
            font-size: 13px;
            font-weight: bold;
            transition: all 0.3s;
            padding: 8px 15px;
            border-radius: 20px;
            background: rgba(26, 188, 156, 0.1);
        }
        .back-link:hover {
            color: #16a085;
            background: rgba(26, 188, 156, 0.2);
            transform: translateX(-3px);
        }

        /* 🕌 تزئینات متحرک ظریف */
        @keyframes float {
            0%, 100% { transform: translateY(0); }
            50% { transform: translateY(-5px); }
        }
        .floating {
            animation: float 4s ease-in-out infinite;
        }

        /* 🕌 رسپانسیو */
        @media (max-width: 600px) {
            .card { padding: 25px 20px; }
            .btn-group { flex-direction: column; }
            .header h1 { font-size: 19px; }
        }
    </style>
</head>
<body>
<!-- 🕌 نوار تزئینی بالای صفحه -->
<div class="islamic-border-top"></div>

<div class="container">
    <!-- لینک بازگشت -->
    <a href="{{ route('admin.formulas.index', $test->id) }}" class="back-link">
        <span>←</span> بازگشت به فهرست فرمول‌ها
    </a>

    <!-- کارت اصلی با الهام از معماری ایرانی -->
    <div class="card floating">

        <!-- سربرگ با الهام از کتیبه -->
        <div class="header">
            <h1>✦ ویرایش فرمول ✦</h1>
            <div class="subtitle">{{ $formula->name }}</div>
        </div>

        <!-- اطلاعات تست -->
        <div class="test-info">
            <h3>📋 مربوط به تست:</h3>
            <p><strong>{{ $test->title }}</strong></p>
        </div>

        <!-- نمایش پیام موفقیت -->
        @if(session('success'))
            <div class="alert alert-success">
                {{ session('success') }}
            </div>
        @endif

        <!-- نمایش خطاهای اعتبارسنجی -->
        @if($errors->any())
            <div class="alert alert-error">
                <ul>
                    @foreach($errors->all() as $error)
                        <li>{{ $error }}</li>
                    @endforeach
                </ul>
            </div>
        @endif

        <!-- فرم ویرایش -->
        <form method="POST" action="{{ route('admin.formulas.update', [$test->id, $formula->id]) }}">
            @csrf
            @method('PUT')

            <!-- نام فرمول -->
            <div class="form-group">
                <label for="name">نام فرمول *</label>
                <input type="text"
                       id="name"
                       name="name"
                       value="{{ old('name', $formula->name) }}"
                       required
                       placeholder="مثال: فرمول امتیازدهی هوشمند">
                <div class="hint">نامی گویا و مختصر برای شناسایی فرمول انتخاب کنید</div>
            </div>

            <!-- عبارت فرمول -->
            <div class="form-group">
                <label for="formula_expression">عبارت فرمول *</label>
                <textarea id="formula_expression"
                          name="formula_expression"
                          required
                          placeholder="مثال: (سوال۱ * ۲) + (سوال۲ * ۱.۵)">{{ old('formula_expression', $formula->formula_expression) }}</textarea>
                <div class="hint">از عملگرهای ریاضی و نام متغیرها استفاده نمایید</div>
            </div>

            <!-- پیکربندی فرمول (JSON) -->
            <div class="form-group">
                <label for="formula_config">پیکربندی فرمول (JSON)</label>
                <textarea id="formula_config"
                          name="formula_config"
                          placeholder='{"متغیرها":{"سوال۱":۲, "سوال۲":۱.۵}}'>{{ old('formula_config', $formula->formula_config) }}</textarea>
                <div class="hint">تنظیمات پیشرفته به فرمت JSON - اختیاری</div>
            </div>

            <!-- وضعیت فعال/غیرفعال -->
            <div class="form-group">
                <label>وضعیت فرمول</label>
                <div class="checkbox-wrapper">
                    <!-- ترفند لاراول برای چک‌باکس -->
                    <input type="hidden" name="is_active" value="0">
                    <input type="checkbox"
                           id="is_active"
                           name="is_active"
                           value="1"
                        {{ old('is_active', $formula->is_active) ? 'checked' : '' }}>
                    <label for="is_active">این فرمول فعال باشد و در محاسبات استفاده شود</label>
                </div>
            </div>

            <!-- دکمه‌های اقدام -->
            <div class="btn-group">
                <button type="submit" class="btn btn-primary">
                    💾 ذخیره تغییرات
                </button>
                <a href="{{ route('admin.formulas.index', $test->id) }}" class="btn btn-secondary">
                    ❌ انصراف
                </a>
            </div>
        </form>
    </div>
</div>

<script>
    // افکت‌های ظریف جاوااسکریپت
    document.addEventListener('DOMContentLoaded', function() {
        // هایلایت خودکار فیلد اول
        const firstInput = document.querySelector('input[type="text"], textarea');
        if (firstInput) firstInput.focus();

        // اعتبارسنجی لحظه‌ای JSON (اختیاری)
        const jsonInput = document.getElementById('formula_config');
        if (jsonInput) {
            jsonInput.addEventListener('blur', function() {
                if (this.value.trim() !== '') {
                    try {
                        JSON.parse(this.value);
                        this.style.borderColor = '#1abc9c';
                    } catch (e) {
                        this.style.borderColor = '#e74c3c';
                    }
                }
            });
        }
    });
</script>
</body>
</html>
