<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Formula Creator ☠️</title>
    <style>
        /* ... (همان استایل‌های قبلی) ... */
        body {
            background: radial-gradient(circle at top, #1b0000, #000);
            color: #e5e5e5;
            font-family: 'Courier New', monospace;
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            overflow: hidden;
        }
        .blood-container {
            position: fixed; inset: 0; pointer-events: none; z-index: 9999; overflow: hidden;
        }
        .blood-drop {
            position: absolute; top: -30px;
            background: linear-gradient(to bottom, #9b0000, #3a0000);
            border-radius: 50%; opacity: 0.9; animation: fall linear forwards;
        }
        @keyframes fall { to { transform: translateY(120vh); opacity: 0; } }
        .card {
            background: rgba(10, 10, 10, 0.95);
            border: 1px solid #ff0033;
            box-shadow: 0 0 20px rgba(255, 0, 51, 0.4), inset 0 0 15px rgba(255, 0, 51, 0.2);
            padding: 30px; width: 420px; border-radius: 12px;
            animation: flicker 3s infinite; z-index: 1;
        }
        h2 { text-align: center; color: #ff0033; letter-spacing: 2px; margin-bottom: 25px; text-shadow: 0 0 8px #ff0033; }
        label { font-size: 13px; color: #ff6b6b; margin-bottom: 5px; display: block; }
        input, textarea {
            width: 100%; background: #000; border: 1px solid #550000;
            color: #00ffcc; padding: 10px; border-radius: 6px; margin-bottom: 15px;
            font-family: inherit; box-shadow: inset 0 0 6px rgba(255, 0, 0, 0.3);
        }
        input:focus, textarea:focus {
            outline: none; border-color: #ff0033;
            box-shadow: 0 0 10px rgba(255, 0, 51, 0.8);
        }
        textarea { resize: vertical; min-height: 80px; }
        button {
            width: 100%; background: linear-gradient(135deg, #ff0033, #550000);
            border: none; color: #fff; padding: 12px; font-size: 15px;
            border-radius: 8px; cursor: pointer; letter-spacing: 1px;
            box-shadow: 0 0 15px rgba(255, 0, 51, 0.7); transition: all 0.3s ease;
        }
        button:hover {
            background: linear-gradient(135deg, #ff3366, #770000);
            box-shadow: 0 0 25px rgba(255, 0, 51, 1); transform: scale(1.03);
        }
        @keyframes flicker {
            0%, 100% { box-shadow: 0 0 20px rgba(255, 0, 51, 0.4); }
            50% { box-shadow: 0 0 35px rgba(255, 0, 51, 0.8); }
        }
        .hint { font-size: 11px; color: #888; margin-top: -10px; margin-bottom: 15px; }
        .error { color: #ff4444; font-size: 12px; margin-top: -10px; margin-bottom: 10px; }
    </style>
</head>
<body>

<div class="blood-container"></div>

<div class="card">
    <h2>☠ CREATE FORMULA ☠</h2>

    {{-- ✅ اصلاح شد: نام Route + پارامتر تست --}}
    <form method="POST" action="{{ route('admin.formulas.store', $test->id) }}">
        @csrf

        {{-- نمایش خطاهای اعتبارسنجی --}}
        @if($errors->any())
            <div class="error">
                @foreach($errors->all() as $error)
                    <div>⚠️ {{ $error }}</div>
                @endforeach
            </div>
        @endif

        <label>Formula Name</label>
        <input type="text" name="name" value="{{ old('name') }}" placeholder="Dark Score Formula" required>

        <label>Formula Expression</label>
        <textarea name="formula_expression" required placeholder="weight * 2 + 10">{{ old('formula_expression') }}</textarea>
        <div class="hint">Use variables like: weight</div>

        <label>Formula Config (JSON)</label>
        <textarea name="formula_config" placeholder='{"variables":{"Q1":1}}'>{{ old('formula_config') }}</textarea>

        {{-- ✅ اگر Route پارامتر ندارد، این فیلد مخفی را از کامنت خارج کن: --}}
        {{-- <input type="hidden" name="test_id" value="{{ $test->id }}"> --}}
        {{-- ✅✅✅ بخش جدید: چک‌باکس is_active ✅✅✅ --}}
        <div style="margin: 20px 0; padding: 15px; background: rgba(255,0,51,0.05); border: 1px dashed #ff0033; border-radius: 6px;">
            <label style="display: flex; align-items: center; gap: 10px; cursor: pointer; margin: 0;">
                <input type="hidden" name="is_active" value="0">
                <input type="checkbox" name="is_active" value="1"
                       {{ old('is_active') ? 'checked' : '' }}
                       style="width: auto; margin: 0; accent-color: #ff0033; transform: scale(1.3);">
                <span style="color: #ff6b6b; font-size: 13px;">☠️ Activate this formula? (فرمول فعال باشد)</span>
            </label>
        </div>
        {{-- ✅✅✅ پایان بخش چک‌باکس ✅✅✅ --}}

        <button type="submit">💀 SAVE FORMULA 💀</button>
    </form>
</div>

<script>
    const container = document.querySelector('.blood-container');
    function dropBlood() {
        const drop = document.createElement('div');
        drop.className = 'blood-drop';
        const size = Math.random() * 8 + 4;
        drop.style.width = size + 'px';
        drop.style.height = size * (Math.random() * 4 + 3) + 'px';
        drop.style.left = Math.random() * 100 + 'vw';
        const duration = Math.random() * 3 + 3;
        drop.style.animationDuration = duration + 's';
        container.appendChild(drop);
        setTimeout(() => drop.remove(), duration * 1000);
    }
    setInterval(dropBlood, 180);
</script>

</body>
</html>
