<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up()
    {
        Schema::create('formula_results', function (Blueprint $table) {
            $table->id();
            $table->foreignId('test_id')->constrained()->cascadeOnDelete();
            $table->foreignId('user_id')->constrained()->cascadeOnDelete(); // کسی که تست داده
            $table->foreignId('formula_id')->constrained()->cascadeOnDelete();

            $table->string('formula_code'); // کد فرمول (مثلاً ANXIETY_SCORE)
            $table->json('input_values');   // ورودی‌های لحظه محاسبه {"Q1": 5, "Q2": 3}
            $table->text('expression_snapshot'); // فرمول در لحظه اجرا
            $table->string('result_type');  // number, string, boolean
            $table->text('result_value');   // خروجی نهایی
            $table->decimal('execution_time', 10, 6)->nullable(); // سرعت اجرا

            $table->timestamps();

            // ایندکس برای سرعت بیشتر در جستجو
            $table->index(['test_id', 'user_id']);
        });
    }

    public function down()
    {
        Schema::dropIfExists('formula_results');
    }
};
