<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */


    public function up()
    {
        Schema::table('formulas', function (Blueprint $table) {
            // ✅ فقط ستون variables را اضافه می‌کنیم (بقیه وجود دارند)
            if (!Schema::hasColumn('formulas', 'variables')) {
                $table->json('variables')->nullable()->after('formula_expression');
            }
        });
    }

    public function down()
    {
        Schema::table('formulas', function (Blueprint $table) {
            if (Schema::hasColumn('formulas', 'variables')) {
                $table->dropColumn('variables');
            }
        });
    }
};
