<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('questions', function (Blueprint $table) {
            $table->foreignId('formula_id')->nullable()->after('text')->constrained()->onDelete('set null');
            // حذف ستون‌های قدیمی فرمول از questions
            $table->dropColumn(['formula_expression', 'formula_config']);
        });
    }

    public function down(): void
    {
        Schema::table('questions', function (Blueprint $table) {
            $table->dropForeign(['formula_id']);
            $table->dropColumn('formula_id');
            $table->text('formula_expression')->nullable()->after('text');
            $table->json('formula_config')->nullable()->after('formula_expression');
        });
    }
};