<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('tests', function (Blueprint $table) {
            $table->dropColumn(['formula_type', 'formula_expression', 'formula_config']);
        });
    }

    public function down(): void
    {
        Schema::table('tests', function (Blueprint $table) {
            $table->string('formula_type')->default('predefined')->after('description');
            $table->text('formula_expression')->nullable()->after('formula_type');
            $table->json('formula_config')->nullable()->after('formula_expression');
        });
    }
};