<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('tests', function (Blueprint $table) {
            // تغییر نوع فرمول به دو حالت: predefined یا custom
            $table->string('formula_type')->default('predefined')->change();
            
            // عبارت فرمول برای حالت custom
            $table->text('formula_expression')->nullable()->after('formula_type');
            // مثال: "({Q1} + {Q2}) * 2"
            
            // تنظیمات فرمول به صورت JSON
            $table->json('formula_config')->nullable()->after('formula_expression');
            // مثال: {"Q1": 1, "Q2": 2, "Q3": 3} ← نگاشت متغیر به question_id
        });
    }

    public function down(): void
    {
        Schema::table('tests', function (Blueprint $table) {
            $table->dropColumn(['formula_expression', 'formula_config']);
            $table->string('formula_type')->default('weighted')->change();
        });
    }
};