<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;

class Test extends Model
{
    use HasFactory;

    protected $fillable = [
        'title',
        'description',
        'is_active',  // ✅ آندرلاین نه خط تیره
        'formula_type',
        'formula_expression',
        'formula_config',
    ];

    protected $casts = [
        'is_active' => 'boolean',  // ✅ آندرلاین نه خط تیره
        'formula_config' => 'array',
    ];

    /**
     * رابطه با سوالات (جمع)
     */
    public function questions(): HasMany  // ✅ questions نه question
    {
        return $this->hasMany(Question::class)->orderBy('order');
    }

     public function formulas(): HasMany
    {
        return $this->hasMany(Formula::class);
    }

    /**
     * رابطه با تلاش‌ها
     */
    public function attempts(): HasMany  // ✅ hasMany نه hasmany
    {
        return $this->hasMany(TestAttempt::class);
    }
}