<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Formula;
use App\Models\FormulaResult;
use App\Models\Test;
use App\Models\TestAttempt;

class FormulaResultController extends Controller
{
    /**
     * نمایش لیست نتایج فرمول‌ها برای یک تست
     */
    public function index($testId)
    {
        try {
            $test = Test::findOrFail($testId);

            $formulas = Formula::where('test_id', $testId)
                ->orderBy('priority')
                ->get();

            $latestResults = FormulaResult::where('test_id', $testId)
                ->orderBy('created_at', 'desc')
                ->get()
                ->groupBy('formula_code');

            $attempts = TestAttempt::where('test_id', $testId)
                ->orderBy('created_at', 'desc')
                ->limit(10)
                ->get();

            return view('admin.formula-results.index', compact('test', 'formulas', 'latestResults', 'attempts'));

        } catch (\Throwable $e) {
            return response()->json([
                'error' => $e->getMessage(),
                'file' => $e->getFile() . ':' . $e->getLine(),
            ], 500);
        }
    }

    /**
     * نمایش جزئیات نتایج برای یک اجرای خاص
     */
    public function show($testId, $attemptId)
    {
        try {
            $test = Test::findOrFail($testId);

            // گرفتن اطلاعات attempt
            $attempt = \App\Models\TestAttempt::findOrFail($attemptId);

            // گرفتن پاسخ‌های کاربر با جزئیات سوال و گزینه
            $answers = \App\Models\Answer::where('attempt_id', $attemptId)
                ->with(['question.options'])
                ->get();

            // گرفتن نتایج فرمول‌ها
            $results = \App\Models\FormulaResult::where('test_id', $testId)
                ->where('attempt_id', $attemptId)
                ->orderBy('created_at')
                ->get();

            // گرفتن تمام فرمول‌ها برای نمایش expression
            $formulas = \App\Models\Formula::where('test_id', $testId)
                ->get()
                ->keyBy('id');

            return view('admin.formula-results.show', compact(
                'test',
                'attempt',
                'answers',
                'results',
                'formulas'
            ));

        } catch (\Throwable $e) {
            return response()->json([
                'error' => $e->getMessage(),
                'file' => $e->getFile() . ':' . $e->getLine(),
            ], 500);
        }
    }
}
