<?php

namespace App\Http\Controllers\Admin;  // ✅ اضافه کردن \Admin
use App\Http\Controllers\Controller;
use App\Models\Test;
use App\Models\Formula;
use Illuminate\Http\Request;
use App\Models\Question;

class AdminQuestionController extends Controller
{
    public function questions($id){

        $test=Test::findOrFail($id);
        $questions=Question::where('test_id',$id)->OrderBy('order','asc')->with('options')->get();

        return view('admin.questions.index', compact('test','questions'));
    }

    public function create($id){
        $test=Test::findOrFail($id);
        $formulas = Formula::where('test_id', $id)
            ->where('is_active', true)
            ->get();
        return view('admin.questions.create',compact('test','formulas'));
    }

    public function store(Request $request, $id){
        $validated=$request->validate([
        'text' => 'required|string|max:1000',
        'type' => 'required|in:multiple_choice,text',
        'order' => 'required|integer|min:1',
        'is_required' => 'nullable|boolean',
        'formula_id' => 'nullable|exists:formulas,id',
        'options' => 'required_if:type,multiple_choice|array',
        'options.*.text' => 'required_with:options|string|max:255',
        'options.*.score_value' => 'nullable|numeric',
    ]);
     $question = Question::create([
        'test_id' => $id,
        'text' => $validated['text'],
        'type' => $validated['type'],
        'order' => $validated['order'],
        'is_required' => $validated['is_required'] ?? false,
        'formula_id' => $validated['formula_id'] ?? null,
    ]);

    // ۳. ذخیره گزینه‌ها (اگر تستی بود)
    if ($question->type === 'multiple_choice' && !empty($validated['options'])) {
        foreach ($validated['options'] as $optionData) {
            $question->options()->create([
                'text' => $optionData['text'],
                'score_value' => $optionData['score_value'] ?? 0,
            ]);
        }
    }

    // ۴. بازگشت به لیست
    return redirect()->route('admin.tests.questions', $id)->with('success', 'سوال با موفقیت اضافه شد');

    }

    public function edit($id, $qid)
    {
        $test = Test::findOrFail($id);

        $question = Question::with('options')  // ← گزینه‌ها را لود کن
            ->findOrFail($qid);

        $formulas = Formula::where('test_id', $id)
            ->where('is_active', true)
            ->get();

        return view('admin.questions.edit', compact('test', 'question', 'formulas'));
    }

    public function update(Request $request,$id,$qid){

    $validated=$request->validate([
        'text' => 'required|string|max:1000',
        'type' => 'required|in:multiple_choice,text',
        'order' => 'required|integer|min:1',
        'is_required' => 'nullable|boolean',
        'formula_id' => 'nullable|exists:formulas,id',
        'options' => 'required_if:type,multiple_choice|array',
        'options.*.text' => 'required_with:options|string|max:255',
        'options.*.score_value' => 'nullable|numeric',]);

        $test=Test::findOrFail($id);
        $question=Question::findOrFail($qid);
        $question->update([
        'text' => $validated['text'],
        'type' => $validated['type'],
        'order' => $validated['order'],
        'is_required' => $validated['is_required'] ?? false,
        'formula_id' => $validated['formula_id'] ?? null,
    ]);
    if ($question->type === 'multiple_choice') {
        $question->options()->delete();  // حذف گزینه‌های قدیمی

        if (!empty($validated['options'])) {
            foreach ($validated['options'] as $optionData) {
                $question->options()->create([  // ← create نه update!
                    'text' => $optionData['text'],
                    'score_value' => $optionData['score_value'] ?? 0,
                ]);
            }
        }
    } else {
        // اگر تشریحی شد، گزینه‌های قدیمی را حذف کن
        $question->options()->delete();
    }



    return redirect()->route('admin.questions.index',$id)->with('success', 'سوال با موفقیت ویرایش شد ، درود بر زکاوت توسعه دهنده');

    }

    public function destroy($id,$qid){
        $test=Test::findOrFail($id);
        $question=Question::findOrFail($qid);
        $question->delete();
        return redirect()->route('admin.questions.index',$id)->with('success', 'سوال با موفقیت حذف شد،اگه نمیخواستیش برای چی اصلا نوشتیش؟');


    }


}
